
vocalizeList = { "(None)" , "Ace" , "Brandon" , "Charles" , "David" , "Jim" , "Joy" ,  "Madame_Moisture" , "Marissa" , "Matt" , "Nick" , "Phil" , "Ryan" , "Sara" , "Joy_swedish" , "Random" , "Blender" }
vocalize = { "(None)" , "(None)" } -- defaults

function VocalizeOption()
	local modList = vocalizeList
	local t = {
		Name = "Vocalize",
		LayoutType = "ShowAllInRow",
		SelectType = "SelectOne",
		OneChoiceForAllPlayers = false,
		ExportOnChange = false,
		Choices = modList,
		
		LoadSelections = function(self, list, pn)
			for n = 1, table.getn(modList) do
				if vocalize[pn+1] == modList[n] then list[n] = true; else list[n] = false end
			end
		end,

		SaveSelections = function(self, list, pn)
			for n = 1, table.getn(modList) do
				if list[n] then vocalize[pn+1] = modList[n] end
			end
		end
		
	}
	setmetatable(t, t)
	return t
end

function VocalizeTest(self,j)
	local digits = {""}
	score = string.gsub(score,'%%','')
	local int = math.floor(score)
	local dec = string.sub(score,string.len(score)-1)
	if int == 100 then digits[1] = '100percent'
	else
		if int < 20 then
			digits[1] = int; digits[2] = 'point'
		elseif math.mod(int,10) == 0 then
			digits[1] = int; digits[2] = 'point'
		else
			digits[1] = int - math.mod(int,10); digits[2] = math.mod(int,10); digits[3] = 'point'
		end
		for i=2,4 do
			if not digits[i] then digits[i] = string.sub(dec,1,1); digits[i+1] = string.sub(dec,2,2) break end
		end
	end
	if digits[j] then
		if j == 1 then
			speaker = Voice
			if Voice == 'Random' then speaker = vocalizeList[math.random(2,table.getn(vocalizeList)-2)] end
		end
		
		if Voice == 'Blender' then speaker = vocalizeList[math.random(2,table.getn(vocalizeList)-2)] end
		if digits[j] == '100percent' then digits[j] = digits[j] .. math.random(1,loadstring('if _G[speaker] then return _G[speaker].quads else return 1 end')()) end
		Path = THEME:GetPath( EC_SOUNDS, '', speaker ..'/'..digits[j]..'.ogg' )
		SOUND:PlayOnce( Path )
		self:sleep(loadstring('if _G[speaker] then return _G[speaker].z' .. digits[j] .. ' else return .5 end')())
		if not digits[j+1] then self:sleep(.3) end
	end
end

function Vocalize(self,pn,j)
	if GAMESTATE:IsPlayerEnabled(pn-1) then
		local score = SCREENMAN:GetTopScreen():GetChild('PercentP'..pn):GetChild('PercentP'..pn):GetText()
		local digits = {""}
		score = string.gsub(score,'%%','')
		local int = math.floor(score)
		local dec = string.sub(score,string.len(score)-1)
		if int == 100 then digits[1] = '100percent'
		elseif tonumber(score) == 0 then digits[1] = nil
		else
			if int < 20 then
				digits[1] = int; digits[2] = 'point'
			elseif math.mod(int,10) == 0 then
				digits[1] = int; digits[2] = 'point'
			else
				digits[1] = int - math.mod(int,10); digits[2] = math.mod(int,10); digits[3] = 'point'
			end
			for i=2,4 do
				if not digits[i] then digits[i] = string.sub(dec,1,1); digits[i+1] = string.sub(dec,2,2) break end
			end
		end
		if digits[j] and vocalize[pn] ~= '(None)' then
			if j == 1 then
				speaker = vocalize[pn]
				if vocalize[pn] == 'Random' then speaker = vocalizeList[math.random(2,table.getn(vocalizeList)-3)] end
			end
			
			if vocalize[pn] == 'Blender' then speaker = vocalizeList[math.random(2,table.getn(vocalizeList)-3)] end
			if digits[j] == '100percent' then digits[j] = digits[j] .. math.random(1,loadstring('if _G[speaker] then return _G[speaker].quads else return 1 end')()) end
			Path = THEME:GetPath( EC_SOUNDS, '', speaker ..'/'..digits[j]..'.ogg' )
			SOUND:PlayOnce( Path )
			self:sleep(loadstring('if _G[speaker] then return _G[speaker].z' .. digits[j] .. ' else return .5 end')())
			if not digits[j+1] then self:sleep(.3) end
		end
	end
end

	Ace = { z0 = .9,
		z1 = .7,
		z2 = .7,
		z3 = .7,
		z4 = .9,
		z5 = .9,
		z6 = .9,
		z7 = 1.2,
		z8 = 1.2,
		z9 = .9,
		z10 = .7,
		z11 = .7,
		z12 = .9,
		z13 = 1.2,
		z14 = 1.2,
		z15 = 1.2,
		z16 = 1.2,
		z17 = 1.2,
		z18 = 1.2,
		z19 = 1.2,
		z20 = .7,
		z30 = .4,
		z40 = .7,
		z50 = .4,
		z60 = .7,
		z70 = .7,
		z80 = .4,
		z90 = .4,
		z100percent1 = 4.7,
		z100percent2 = 4.9,
		z100percent3 = 15.4,
		z100percent4 = 7.9,
		z100percent5 = 10.9,
		z100percent6 = 9.7,
		z100percent7 = 9.9,
		z100percent8 = 11.9,
		zpoint = .7,
		quads = 8 }

	Joy_swedish = { z0 = .6,
			z1 = .5,
			z2 = .5,
			z3 = .5,
			z4 = .5,
			z5 = .5,
			z6 = .5,
			z7 = .5,
			z8 = .6,
			z9 = .5,
			z10 = .6,
			z11 = .6,
			z12 = .5,
			z13 = .7,
			z14 = .7,
			z15 = .7,
			z16 = .7,
			z17 = .7,
			z18 = .7,
			z19 = .7,
			z20 = .7,
			z30 = .7,
			z40 = .8,
			z50 = .7,
			z60 = .7,
			z70 = .7,
			z80 = .7,
			z90 = .75,
			z100percent1 = 23.3,
			zpoint = .6,
			quads = 1 }

	Joy = { z0 = .6,
			z1 = .45,
			z2 = .5,
			z3 = .5,
			z4 = .5,
			z5 = .5,
			z6 = .5,
			z7 = .5,
			z8 = .4,
			z9 = .5,
			z10 = .4,
			z11 = .5,
			z12 = .6,
			z13 = .7,
			z14 = .7,
			z15 = .7,
			z16 = .7,
			z17 = .7,
			z18 = .6,
			z19 = .7,
			z20 = .4,
			z30 = .5,
			z40 = .5,
			z50 = .5,
			z60 = .5,
			z70 = .5,
			z80 = .4,
			z90 = .5,
			z100percent1 = 23.3,
			z100percent2 = 10,
			zpoint = .6,
			quads = 2 }

	Matt = { z0 = .6,
			z1 = .5,
			z2 = .5,
			z3 = .5,
			z4 = .5,
			z5 = .5,
			z6 = .5,
			z7 = .5,
			z8 = .5,
			z9 = .5,
			z10 = .5,
			z11 = .6,
			z12 = .6,
			z13 = .6,
			z14 = .6,
			z15 = .6,
			z16 = .7,
			z17 = .7,
			z18 = .7,
			z19 = .7,
			z20 = .6,
			z30 = .4,
			z40 = .5,
			z50 = .5,
			z60 = .6,
			z70 = .5,
			z80 = .5,
			z90 = .5,
			z100percent1 = 1,
			zpoint = .5,
			quads = 1 }

	Phil = { z0 = .6,
			z1 = .5,
			z2 = .5,
			z3 = .65,
			z4 = .6,
			z5 = .55,
			z6 = .6,
			z7 = .6,
			z8 = .5,
			z9 = .5,
			z10 = .5,
			z11 = .6,
			z12 = .7,
			z13 = .6,
			z14 = .6,
			z15 = .6,
			z16 = .6,
			z17 = .65,
			z18 = .6,
			z19 = .6,
			z20 = .3,
			z30 = .4,
			z40 = .3,
			z50 = .3,
			z60 = .4,
			z70 = .4,
			z80 = .3,
			z90 = .4,
			z100percent1 = 2,
			z100percent2 = 2,
			z100percent3 = 1.5,
			zpoint = .45,
			quads = 3 }	
		
	Nick = { z0 = .7,
			z1 = .7,
			z2 = .5,
			z3 = .65,
			z4 = .6,
			z5 = .6,
			z6 = .5,
			z7 = .7,
			z8 = .5,
			z9 = .5,
			z10 = .5,
			z11 = .6,
			z12 = .7,
			z13 = .7,
			z14 = .75,
			z15 = .75,
			z16 = .75,
			z17 = .8,
			z18 = .75,
			z19 = .75,
			z20 = .7,
			z30 = .7,
			z40 = .7,
			z50 = .7,
			z60 = .7,
			z70 = .7,
			z80 = .6,
			z90 = .7,
			z100percent1 = 2.5,
			zpoint = .45,
			quads = 1 }
			
	Ryan = { z0 = .7,
			z1 = .5,
			z2 = .5,
			z3 = .5,
			z4 = .6,
			z5 = .5,
			z6 = .7,
			z7 = .5,
			z8 = .5,
			z9 = .5,
			z10 = .5,
			z11 = .7,
			z12 = .6,
			z13 = .8,
			z14 = .8,
			z15 = .8,
			z16 = .8,
			z17 = .9,
			z18 = .8,
			z19 = .8,
			z20 = .5,
			z30 = .5,
			z40 = .6,
			z50 = .7,
			z60 = .7,
			z70 = .7,
			z80 = .6,
			z90 = .65,
			z100percent1 = 11,
			zpoint = .5,
			quads = 1 }
			
	Jim = { z0 = .6,
			z1 = .5,
			z2 = .5,
			z3 = .6,
			z4 = .6,
			z5 = .55,
			z6 = .6,
			z7 = .6,
			z8 = .4,
			z9 = .5,
			z10 = .5,
			z11 = .6,
			z12 = .8,
			z13 = .6,
			z14 = .6,
			z15 = .6,
			z16 = .7,
			z17 = .65,
			z18 = .6,
			z19 = .6,
			z20 = .6,
			z30 = .6,
			z40 = .6,
			z50 = .6,
			z60 = .6,
			z70 = .6,
			z80 = .5,
			z90 = .6,
			z100percent1 = 2,
			z100percent2 = 2,
			z100percent3 = 2,
			z100percent4 = 4,
			z100percent5 = 4,
			z100percent6 = 2,
			z100percent7 = 2,
			z100percent8 = 2,
			z100percent9 = 2,
			z100percent10 = 2,
			zpoint = .4,
			quads = 10 }

	Brandon = { z0 = .6,
			z1 = .4,
			z2 = .4,
			z3 = .5,
			z4 = .5,
			z5 = .5,
			z6 = .5,
			z7 = .5,
			z8 = .4,
			z9 = .5,
			z10 = .5,
			z11 = .5,
			z12 = .6,
			z13 = .7,
			z14 = .7,
			z15 = .8,
			z16 = .7,
			z17 = .7,
			z18 = .7,
			z19 = .7,
			z20 = .4,
			z30 = .5,
			z40 = .4,
			z50 = .5,
			z60 = .5,
			z70 = .5,
			z80 = .4,
			z90 = .5,
			z100percent1 = 1.5,
			zpoint = .5,
			quads = 1 }
			
	Madame_Moisture = { z0 = .8,
			z1 = .6,
			z2 = .6,
			z3 = .6,
			z4 = .6,
			z5 = .6,
			z6 = .6,
			z7 = .7,
			z8 = .5,
			z9 = .5,
			z10 = .8,
			z11 = .7,
			z12 = .8,
			z13 = .7,
			z14 = .9,
			z15 = .9,
			z16 = 1.4,
			z17 = 1,
			z18 = .7,
			z19 = .9,
			z20 = .6,
			z30 = .6,
			z40 = .6,
			z50 = .6,
			z60 = .65,
			z70 = .7,
			z80 = .5,
			z90 = 1,
			z100percent1 = 3,
			z100percent2 = 3,
			z100percent3 = 16,
			z100percent4 = 4,
			z100percent5 = 3,
			z100percent6 = 4,
			zpoint = .5,
			quads = 6 }				
			
	Marissa = { z0 = .5,
			z1 = .3,
			z2 = .4,
			z3 = .5,
			z4 = .4,
			z5 = .4,
			z6 = .5,
			z7 = .4,
			z8 = .4,
			z9 = .4,
			z10 = .3,
			z11 = .6,
			z12 = .6,
			z13 = .3,
			z14 = .4,
			z15 = .5,
			z16 = .5,
			z17 = .6,
			z18 = .5,
			z19 = .5,
			z20 = .4,
			z30 = .4,
			z40 = .4,
			z50 = .3,
			z60 = .4,
			z70 = .5,
			z80 = .4,
			z90 = .4,
			z100percent1 = 1.5,
			z100percent2 = 8,
			zpoint = .7,
			quads = 2 }
			
	Charles = { z0 = .5,
			z1 = .5,
			z2 = .5,
			z3 = .5,
			z4 = .5,
			z5 = .5,
			z6 = .5,
			z7 = .5,
			z8 = .4,
			z9 = .5,
			z10 = .5,
			z11 = .5,
			z12 = .6,
			z13 = .7,
			z14 = .7,
			z15 = .7,
			z16 = .7,
			z17 = .7,
			z18 = .7,
			z19 = .7,
			z20 = .6,
			z30 = .6,
			z40 = .7,
			z50 = .5,
			z60 = .6,
			z70 = .6,
			z80 = .6,
			z90 = .6,
			z100percent1 = 2,
			z100percent2 = 2,
			z100percent3 = 2,
			z100percent4 = 1,
			z100percent5 = 2,
			z100percent6 = 2,
			z100percent7 = 1,
			z100percent8 = 1,
			z100percent9 = 2,
			z100percent10 = 2,
			z100percent11 = 3,
			z100percent12 = 2,
			z100percent13 = 2,
			zpoint = .6,
			quads = 13 }
			
	Sara = { z0 = .8,
			z1 = .5,
			z2 = .5,
			z3 = .7,
			z4 = .9,
			z5 = .9,
			z6 = .4,
			z7 = .5,
			z8 = .5,
			z9 = .5,
			z10 = .5,
			z11 = .8,
			z12 = .9,
			z13 = 1.5,
			z14 = .8,
			z15 = .8,
			z16 = 1.5,
			z17 = 1.4,
			z18 = 1.4,
			z19 = .8,
			z20 = .8,
			z30 = 1.7,
			z40 = .8,
			z50 = .8,
			z60 = .8,
			z70 = 1,
			z80 = .9,
			z90 = .8,
			z100percent1 = 3,
			z100percent2 = 3,
			z100percent3 = 3,
			zpoint = .7,
			quads = 3 }	
			
		David = { z0 = .6,
			z1 = .5,
			z2 = .5,
			z3 = .6,
			z4 = .6,
			z5 = .55,
			z6 = .6,
			z7 = .6,
			z8 = .4,
			z9 = .5,
			z10 = .5,
			z11 = .6,
			z12 = .7,
			z13 = .6,
			z14 = .6,
			z15 = .6,
			z16 = .7,
			z17 = .65,
			z18 = .6,
			z19 = .6,
			z20 = .6,
			z30 = .6,
			z40 = .6,
			z50 = .6,
			z60 = .6,
			z70 = .6,
			z80 = .5,
			z90 = .6,
			z100percent1 = 3,
			zpoint = .4,
			quads = 1 }	